<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*/ /** */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions //no, it can't, you shouldn't autoload classes you're extending -- MG 2014-05-22
require_once 'admin_controller.php';
require_once APPPATH.'/third_party/Paginator.php';
require_once APPPATH.'models/mailbox.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/ 
class Global_search_controller extends Admin_controller
{
	
	/* -----------------------------*
	 *  USER_SETTINGS TAB FUNCTIONS       *
	 * -----------------------------*/
	public function index() { 
		$this->search();
	}
	
	
	/**
	 * Displays a single message.
	 * @param int
	 */
	public function view($message_id){
		$this->eventlog->create_event( 8,$message_id ,3 ,$this->user->id(), "View Message", time(), 1);
		//check to make sure the message id makes sense
		if(!Message::formatted_like_an_id($message_id)) show_404();
		
		//check to see if the message exists
		$message = Message::find_one($message_id);
		if(!Message::is_an_entity($message)) show_404();
		$data = compact('message');
		
		$html = $data['message']->html;
		$html = mb_substr($html,mb_strpos($html,'<body'),mb_strlen($html) - mb_strpos($html,'<body'));
		$html = str_replace('<body','<div',$html);
		$html = str_replace('</body','</div',$html);
		$html = str_replace('</html>','',$html);
		$html = purify($html);
		$data['html'] = $html;
		
		$data['title'] = 'Direct API: Message View';
		$data['active_tab'] = array('global_search'=>true);
		$data['show'] = $this->user->navigation_tabs;	
		
		//grab a list of applications the user has access to
#			$app_access = $this->permissions->get_application_admin_permission($this->user->user_org_id); //this variable doesn't appear to be used anywhere
				
		$this->load->view('api/global_search/view', $data);
	}
	
	/** Gets an attachment from the message with a given name
	 * @param int
	 * @param string
	 */
	public function get_attachment($message_id,$filename){
		//should really be an error, but keeping false to be backwards-compatible since we don't have the time to do a lot of tests right now
		if(!Message::formatted_like_an_id($message_id)) return false; 
		if(!$this->is->nonempty_string($filename)) return false;
		$filename = base64_decode(rawurldecode($filename));
		
		//find the message
		$message = Message::find_one($message_id);
		if(!Message::is_an_entity($message)){
			return false;
		}	
				
		if(array_key_exists($filename, $message->attachment_files))
			$binary_string = $message->attachment_files[$filename];
		elseif(array_key_exists($filename, $message->inline_attachment_files))
			$binary_string = $message->inline_attachment_files[$filename];
		else
			return false; //attachment doesn't exist
			
		header("Content-Type: application/force-download");
		header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
		header("Content-Transfer-Encoding: binary");
		echo $binary_string;		
	}
	
	/**
	* Show the raw mime for a message
	* @param int
	*/
	public function raw($message_id){
		$this->eventlog->create_event( 8,$message_id ,3 ,$this->user->id(), "View Raw Message", time(), 1);
		//check to make sure the message id makes sense
		if(!Message::formatted_like_an_id($message_id)) show_404();
		
		//check to see if the message exists
		$message = Message::find_one($message_id);
		if(!Message::is_an_entity($message)) show_404();
		$data = compact('message');		
		
		$data['title'] = 'Direct API: Message View';
		$data['active_tab'] = array('global_search'=>true);
		$data['show'] = $this->user->navigation_tabs;	
	
		//grab a list of applications the user has access to
#		$app_access = $this->permissions->get_application_admin_permission($id); //doesn't appear to be used
	
#		print_r($message->raw_mime); //since someone set up a view, I'm assuming that using that the intention was to use it
		$this->load->view('api/global_search/raw', $data); 
	}	
	
	/*
	 * loads the search screen.
	 */
	public function search()
	{
		$pages = new Paginator('');
		$pages->page_setup($bar_page, $jump_page, $items_per_page, $destination_page);
		$form_data = $this->input->post();
		
		$data['title'] = 'Direct API: Global Search';
		$data['active_tab'] = array('global_search'=>true);
		$data['show'] = $this->user->navigation_tabs;
	
		//get user id from session to get permissions
		$data['user_id'] = $this->user->user_id;

		//grab a list of applications the user has access to
#		$app_access = $this->permissions->get_application_admin_permission($this->user->user_org_id);	//this isn't used anywhere
		
		//set options for comparing
		$data['compare'] = array(
			'contains' => 'Contains',
			'equals' => 'Equals'
		);

		$data['rows'] = array('From'=>'sender','To' =>'recipients','Subject'=>'subject','Body'=>'plain','Attachments'=>'attachments');
		$filters = array_values($data['rows']);
		
		$data['messages'] = array();
		$data['folders'] = array();
		$messages = array();
		//get direction
		if(isset($form_data['order'])){
			$form_data['direction'] = $this->direction_check($form_data['order'],$form_data['lastorder'],$form_data['direction'],$form_data['change']);
		}
		else{
			$form_data['direction'] = "DESC";
			$form_data['order'] = "timestamp";
		}
		
		if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
		else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }
		if(isset($form_data['mailbox']) && $form_data['mailbox'] !== "ALL" && Mailbox::formatted_like_an_id($form_data['mailbox'])){
			$know_folders = array('inbox','sent','draft','archived');
			$mailbox = Mailbox::find_one( array('id' => $form_data['mailbox']) );
			if(Mailbox::is_an_entity($mailbox)){
				$data['folders'] = $this->get_folders($mailbox);

				if(!isset($form_data['folder']) || $form_data['folder'] === "ALL"){
					$form_data['folder_name'] = false;
					$this->apply_limit_filter($filters, $form_data, $items_per_page, $destination_page);
					$messages = $mailbox->messages();
					$this->apply_filter($filters, $form_data);
					$size = $mailbox->messages_count();
					
				}
				else if(Folder::formatted_like_an_id($form_data['folder'])){
					$folder = first_element( $mailbox->folders( array('id' => $form_data['folder']) ) );
					if(Folder::is_an_entity($folder)){
						$form_data['folder_name'] = $folder->name;
						$this->apply_limit_filter($filters, $form_data, $items_per_page, $destination_page);
						$messages = $folder->messages();
						$this->apply_filter($filters, $form_data);
						$size = $folder->messages_count();
					}
				}
				else{
					if(in_array($form_data['folder'], $know_folders)){
						$form_data['folder_name'] = ucfirst($form_data['folder']);
						$this->apply_limit_filter($filters, $form_data, $items_per_page, $destination_page, true);
						$relationship_name = $form_data['folder'];
						if($form_data['folder'] != 'draft') $relationship_name .= '_message';
						$message_count_method = $relationship_name.'_count';
						$messages = $mailbox->$relationship_name();
						$this->apply_filter($filters, $form_data);
						$size = $mailbox->$message_count_method();
					}
				}
			}
		}
		else{
			$this->apply_locations($form_data);
			$data["folders"] = array("received"=>"Received","sent"=>"Sent","draft"=>"Draft","archived"=>"Archived");
			$form_data['folder_name'] = false;
			$this->apply_limit_filter($filters, $form_data, $items_per_page, $destination_page);
			$messages = Message::find();
			$this->apply_filter($filters, $form_data);
			$this->apply_locations($form_data);
			$size = Message::count();
		}
		
		
		$data['messages'] = $messages;
		$log = array();
		$log['ids']=array();
		foreach ($messages as $message){
			$log['ids'][]=$message->id;
		}
		foreach ($filters as $key){
			$message_key = 'message_'.$key;
			if(isset($form_data[$message_key])&& $form_data[$message_key]){
					$log[$key]=$form_data[$message_key]."(".$form_data[$message_key."_type"].")";
			}
		}
		
		$other_data = array("mailbox","folder","start_data","end_data","order","direction");
		foreach ($other_data as $other){
			if(isset($form_data[$other])&& $form_data[$other]){
					$log[$other]=$form_data[$other];
			}
		}
		$this->eventlog->create_event(8, 0, 3, $this->user->id(), $this->json->encode($log), time(), 1);
		$pages->items_total = $size;
		$pages->current_page = $destination_page;
		$pages->paginate();
		$form_data['num_pages'] = ceil($size/$items_per_page); //num of log pages
		$form_data['items_per_page'] = $items_per_page;
		$form_data['pagination_bar'] = $pages->display_pages();
		$form_data['items_per_page_dropdown'] = $pages->display_items_per_page();
		$form_data['cur_page'] = $destination_page;
		$form_data['pages'] = $pages;
		$data['mailboxes'] = Mailbox::find();
		$data['form_data'] = $form_data;
		$this->load->view('api/global_search/search', $data); 
	}
	/** ajax call to return folders for a specific mailbox
	 * 
	 * @param int $mailbox_id
	 */
	public function update_folders($mailbox_id){
		if(isset($mailbox_id)){
			if($mailbox_id === "ALL"){
				echo $this->json->encode(array("received"=>"Received","sent"=>"Sent","draft"=>"Draft","archived"=>"Archived"));
				return;
			}
			else if (Mailbox::formatted_like_an_id($mailbox_id)){
				$mailbox = Mailbox::find_one( $mailbox_id );
				if(Mailbox::is_an_entity($mailbox)){
					echo $this->json->encode($this->get_folders($mailbox));
					return;
				}
			}
		}
		echo $this->json->encode(array());
	}
////////////////////////////////////////////////////
// HELPER FUNCTIONS
////////////////////////////////////////////////////
	
	
	/*
	 * Gets the folders for set mailbox
	*/
	protected function get_folders($mailbox){
		if(!Mailbox::is_an_entity($mailbox)) return $this->error->should_be_a_mailbox_entity($mailbox);
		return array('inbox'=>'Inbox','sent'=>'Sent','draft'=>'Draft','archived'=>'Archived') + collect('name', $mailbox->folders);
	}
	
	protected function apply_filter($filters, $form_data){
		foreach($filters as $column){
			$filter = "message_". $column;
			if(!empty($form_data[$filter])){
				switch ($form_data[$filter."_type"]){
					//Note for LIKE clauses, if you want to escape wildcard characters in a LIKE statement, call db()->escape_str() with
					//the last two parameters set to TRUE (one to identify it as a LIKE cause, one to escape wildcards)
					//This will allow searches with user input with LIKE wildcard characters ([]_%^)
					case 'equals':
						//using LIKE clause with "" around the filter for recipients and attachments because they are stored in JSON format
						//This will ensure we get the items with with the exact name, even if there are multiple attachments
						if($column === 'recipients' || $column === 'attachments') {
							Message::db()->like("messages.".$column,  Message::db()->escape_str('"' . $form_data[$filter] . '"', TRUE, TRUE));
						}
						else {
							Message::db()->where('messages.'.$column, $form_data[$filter]);
						}
						
						break;
					case 'contains':
						Message::db()->like("messages.".$column, Message::db()->escape_str($form_data[$filter], TRUE, TRUE));
						break;
				}
			}
		}
		
		if(!empty($form_data['start_date'])){
			Message::db()->where('messages.timestamp >=', strtotime($form_data['start_date']));
		}
		
		if(!empty($form_data['end_date'])){
			Message::db()->where('messages.timestamp <=', strtotime ($form_data['end_date']));
		}
	}
	
	protected function apply_limit_filter($filters, $form_data, $items_per_page, $destination_page){
		$orders = array('timestamp','sender','recipients', 'id', 'subject');
		if(in_array($form_data['order'], $orders)){
			$order = "messages.".$form_data['order'];
		}
		else if($form_data['order'] === 'mailbox'){
			$order = "mailboxes.name";
		}
		else if($form_data['order'] === 'folder'  && !$form_data['folder_name']){
			$order = "messages.archived ".$form_data['direction'].", messages.sent ".$form_data['direction'].", messages.draft ".$form_data['direction'].", folders.name";
		}
		else{
			$order = "messages.timestamp";
		}
		$this->apply_filter($filters, $form_data);
		Message::db()->order_by($order,$form_data['direction']);
		$offset = (($destination_page-1)*$items_per_page);
		Message::db()->limit($items_per_page,$offset); //this is to limit
		$select = "mailboxes.name";
		if(!($offset && $form_data['mailbox'] !== 'ALL')){
			$select .= ',messages.*';
		}
		if(!$form_data['folder_name']){
			Message::db()->join('folders', 'folder_id = folders.id ','left outer');
			$select .= ",folders.name as folder_name";
		}
		Message::db()->join('mailboxes', 'messages.mailbox_id = mailboxes.id ','left outer');
		Message::db()->select($select);
	}
	
	//chooses which (asc or desc) the table should be
	protected function direction_check($order, $lastorder, $direction, $change){
		//reloaded by filter and not clicking to change direction.  also make sure that it was not changed by user
		if ($change == 'false' && ($direction == "DESC" || $direction == "ASC")){
			return $direction;
		}
		//colum selected is same as last
		if($order == $lastorder){
			if($direction == 'DESC'){
				return 'ASC';
			}
			else{
				return "DESC";
			}
		}
		//clicked on new colum
		else{
			return "DESC";
		}
	}
	
	protected function apply_locations($form_data){
		if(isset($form_data['folder'])){
			if($form_data['folder'] === 'sent'){
				echo 1;
				Message::db()->where("messages.sent",1);
					
			}
			else if($form_data['folder'] === "draft"){
				Message::db()->where("messages.draft",1);
			}
			else if($form_data['folder'] === "archived"){
				Message::db()->where("messages.archived",1);
			}
			else if($form_data['folder'] === "received"){
				Message::db()->where("messages.sent",0);
				Message::db()->where("messages.draft",0);
			}
		}
	}
}